@echo off
Rem 延迟扩展变量，可以实现更灵活的变量更新和引用，避免无法接收非首次用户输入的值
setlocal enabledelayedexpansion

Rem #################################################################
:: 脚本名称：checkfile.bat
:: 脚本参数：无
:: 脚本功能：投产辅助工具
::           ① 投产文件是否存在，不存在将文件清单输出到文件（warn.log）。
::           ② 拷贝投产物到临时目录，为提交Coding做准备。
::           ③ 检查投产物内容是否有变更，没有变更的进行提示。
::           ④ Coding更新后可用于追踪GitBlit事后更新。
::           ⑤ PRD配置文件投产的处理，涉及路径修复。
:: 版本记录：
::           修改日期      修改人              修改描述
::           2025-12-11    polaris             初版
::           2025-12-15    polaris             新增：PRD配置文件投产的处理
Rem #################################################################

:gate
Rem 设置代码页为UTF-8以支持中文字符
chcp 65001 > nul
Rem 窗体标题
title 投产辅助工具 %~nx0
Rem 清理屏幕
cls

echo "/******************** 菜单 ***********************/"
echo "① 投产文件是否存在，不存在将文件清单输出到文件    "
echo "② 拷贝投产物到临时目录，为提交Coding做准备        "
echo "③ 检查投产物内容是否有变更，没有变更的进行提示    "
echo "④ Coding更新后可用于追踪GitBlit事后更新           "
echo "⑤ PRD配置文件投产的处理，涉及路径修复             "
echo "/*********** 是否删除临时投产物（y/n） ***********/"
echo.
echo 欢迎使用【投产辅助工具V1.0.0】
echo.

Rem 参数初始化
set "cmder=ini.cmd"
set "configFile=config.ini"
set "max_params=10"
set "param_count=0"
set "processed_count=0"
set "noneed_count=0"
set "miss_count=0"
set "file_count=0"

echo 读取临时拷贝目录....
for /f "delims=" %%k in ('call %cmder% %configFile% local coding_temp_path') do (set PATH_TEMP_CODING=%%k)
echo 临时拷贝代码库："!PATH_TEMP_CODING!"

set "IF_DELETE_TEMP_PATH=n"
echo 是否删除临时拷贝目录（y：删除；n：不删除（默认，按回车键即可））
set /p IF_DELETE_TEMP_PATH=
if not defined IF_DELETE_TEMP_PATH set IF_DELETE_TEMP_PATH=n
if "%IF_DELETE_TEMP_PATH%" == "y" set IF_DELETE_TEMP_PATH=y
if "%IF_DELETE_TEMP_PATH%" equ "y" (
    echo 静默删除：!PATH_TEMP_CODING!
    rd /s /q "!PATH_TEMP_CODING!"
)

echo 读取投产日期....
for /f "delims=" %%k in ('call %cmder% %configFile% prd date') do (set PRD_DATE=%%k)
echo !PRD_DATE!

Rem 设置日志文件路径
set "logFile=checkfile-!PRD_DATE!.log"
set "missFile=warn-!PRD_DATE!.log"

Rem 定义允许的文件类型
set "allowed_exts=.sql .cfg .sh .txt .zip .xlsx .xls"

Rem 初始化日志文件：创建文件（如果不存在）并清空内容
> "%logFile%" type nul
> "%missFile%" type nul

echo 投产日期：!PRD_DATE! >> "%logFile%"
echo 日志文件路径：!logFile! >> "%logFile%"
echo 临时拷贝代码库："!PATH_TEMP_CODING!" >> "%logFile%"

echo 读取制品信息....
echo 读取制品信息.... >> "%logFile%"
for /f "delims=" %%k in ('call %cmder% %configFile% artifactory pkg_batch') do (set ARTIFACTORY_PKG_BATCH=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% artifactory pkg_ebi_hkb') do (set ARTIFACTORY_PKG_EBI_HKB=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% artifactory pkg_ebi_hks') do (set ARTIFACTORY_PKG_EBI_HKS=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% artifactory pkg_ebi_hku') do (set ARTIFACTORY_PKG_EBI_HKU=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% artifactory pkg_entegor_hkb') do (set ARTIFACTORY_PKG_ENTEGOR_HKB=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% artifactory pkg_entegor_hks') do (set ARTIFACTORY_PKG_ENTEGOR_HKS=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% artifactory pkg_entegor_hku') do (set ARTIFACTORY_PKG_ENTEGOR_HKU=%%k)

echo ETL脚本部署制品工程名：!ARTIFACTORY_PKG_BATCH! >> "%logFile%"
echo EBI资源包部署制品工程名：!ARTIFACTORY_PKG_EBI_HKB! >> "%logFile%"
echo EBI资源包部署制品工程名：!ARTIFACTORY_PKG_EBI_HKS! >> "%logFile%"
echo EBI资源包部署制品工程名：!ARTIFACTORY_PKG_EBI_HKU! >> "%logFile%"
echo Entegor配置部署制品工程名：!ARTIFACTORY_PKG_ENTEGOR_HKB! >> "%logFile%"
echo Entegor配置部署制品工程名：!ARTIFACTORY_PKG_ENTEGOR_HKS! >> "%logFile%"
echo Entegor配置部署制品工程名：!ARTIFACTORY_PKG_ENTEGOR_HKU! >> "%logFile%"

echo 读取本地路径....
echo 读取本地路径.... >> "%logFile%"
for /f "delims=" %%k in ('call %cmder% %configFile% local coding_true_path') do (set PATH_TRUE_CODING=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% local gitblit_etl_path') do (set PATH_ETL_GITBLIT=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% local gitblit_ebi_path') do (set PATH_EBI_GITBLIT=%%k)
for /f "delims=" %%k in ('call %cmder% %configFile% local gitblit_entegor_path') do (set PATH_ENTEGOR_GITBLIT=%%k)

echo 开发代码库路径：!PATH_ETL_GITBLIT! >> "%logFile%"
echo 真实提交代码库：!PATH_TRUE_CODING! >> "%logFile%"
echo 提交EBI代码库：!PATH_EBI_GITBLIT! >> "%logFile%"
echo 提交Entegor代码库：!PATH_ENTEGOR_GITBLIT! >> "%logFile%"


echo 读取通用参数....
echo 读取通用参数.... >> "%logFile%"
for /f "delims=" %%k in ('call %cmder% %configFile% common separator') do (set C_SEPARATOR=%%k)

echo 列分隔符：!C_SEPARATOR!
echo 列分隔符：!C_SEPARATOR! >> "%logFile%"

echo 读取替换规则....
echo 读取替换规则.... >> "%logFile%"
for /L %%i in (1,1,%max_params%) do (
    for /f "delims=" %%a in ('call %cmder% %configFile% rule v_rules_%%i 2^>nul') do (
        if not "%%a"=="" (
            set "PARAM_V_RULES_%%i=%%a"
            set /a "param_count+=1"
            echo 规则%%i：!PARAM_V_RULES_%%i! >> "%logFile%"
        ) else (
            Rem 值为空，跳出循环
            goto :break_loop
        )
    ) || (
        Rem 参数不存在，跳出循环
        goto :break_loop
    )
)
:break_loop

echo 创建制品库空目录....
echo 创建制品库空目录.... >> "%logFile%"
mkdir !PATH_TEMP_CODING!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKB!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKS!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKU!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKB!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKS!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKU!

echo 创建批量脚本子目录....
echo 创建批量脚本子目录.... >> "%logFile%"
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!bin
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!etc
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!etc\exec_cfg
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!etc\export_cfg
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!etc\load_cfg
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!temp_scripts
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!temp_scripts\!PRD_DATE!
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!temp_scripts\!PRD_DATE!\hkb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!temp_scripts\!PRD_DATE!\hks
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hkb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hkb\dev
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hks
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hks\ads
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hks\dev
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hks\pdm
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hku
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hku\ads
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!SQL\hku\pdm
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbdevdb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbdevdb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbdevdb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbdevdb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbsdldb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbsdldb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbsdldb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkbsdldb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksadsdb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksadsdb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksadsdb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksadsdb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksdevdb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksdevdb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksdevdb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hksdevdb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkspdmdb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkspdmdb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkspdmdb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkspdmdb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkssdldb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkssdldb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkssdldb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkssdldb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkuadsdb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkuadsdb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkuadsdb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkuadsdb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkupdmdb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkupdmdb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkupdmdb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\hkupdmdb\VIEW
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\publicdb
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\publicdb\data
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\publicdb\TABLE
mkdir !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!data\publicdb\VIEW

echo 正在检查投产物清单....
echo 正在检查投产物清单.... >> "%logFile%"
for /f "tokens=*" %%f in (filelist-!PRD_DATE!.txt) do (
    Rem 单行记录处理
    for /f "tokens=1,2 delims=%C_SEPARATOR%" %%x in ("%%f") do (
        set "filename=%%x"
        set "user=%%y"
        if "!user!"=="" (
            echo !filename! 负责人为空！！！
            echo !filename! 负责人为空！！！ >> "%logFile%"
        )
    )
    
    Rem 路径去空格
    set "filepath=!filename: =!"
    
    Rem 按规则替换
    for /L %%p in (1,1,%param_count%) do (
        if defined PARAM_V_RULES_%%p (
            for /f "tokens=1,2" %%b in ("!PARAM_V_RULES_%%p!") do (
                set "filepath=!filepath:%%b=%%c!"
            )
        )
    )
    
    Rem 路径替换正斜杠为反斜杠
    set "filepath=!filepath:/=\!"
    
    Rem 当前正在处理的投产物
    set "check_path=!filepath!"
    echo 正在检查："!check_path!"
    echo 正在检查："!check_path!" >> "%logFile%"
    if exist "!filepath!" (
        echo "!filepath! 文件存在（OK）"
        echo "!filepath! 文件存在（OK）" >> "%logFile%"

        set "str=!filepath!"
        set "target=!filepath!"
        
        Rem COPY标志位复位
        set "COPY_EBI_HKB_FLAG=NO"
        set "COPY_EBI_HKS_FLAG=NO"
        set "COPY_EBI_HKU_FLAG=NO"
        set "COPY_ENTEGOR_HKB_FLAG=NO"
        set "COPY_ENTEGOR_HKS_FLAG=NO"
        set "COPY_ENTEGOR_HKU_FLAG=NO"
        set "COPY_ETL_FLAG=NO"
        
        Rem 路径复位
        set "copy_path="
        set "temp_copy_path="
        
        Rem EBI路径处理
        set "temp=!str:ebi=!"
        if "!temp!" neq "!str!" (
            set "sourceTemp=!temp!"
            
            set "temp=!sourceTemp:\hkb\=!"
            if "!temp!" neq "!sourceTemp!" (
                set "COPY_EBI_HKB_FLAG=YES"
                set "target=!target:%PATH_EBI_GITBLIT%hkb\=!"
                set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_EBI_HKB!!target!"
                set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKB!"
            )
            
            set "temp=!sourceTemp:\hks\=!"
            if "!temp!" neq "!sourceTemp!" (
                set "COPY_EBI_HKS_FLAG=YES"
                set "target=!target:%PATH_EBI_GITBLIT%hks\=!"
                set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_EBI_HKS!!target!"
                set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKS!"
            )
            
            set "temp=!sourceTemp:\hku\=!"
            if "!temp!" neq "!sourceTemp!" (
                set "COPY_EBI_HKU_FLAG=YES"
                set "target=!target:%PATH_EBI_GITBLIT%hku\=!"
                set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_EBI_HKU!!target!"
                set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKU!"
            )
        )
        
        Rem Entegor路径处理
        set "temp=!str:\Entegor\=!"
        if "!temp!" neq "!str!" (
            set "sourceTemp=!temp!"
            
            set "temp=!sourceTemp:\hkb\=!"
            if "!temp!" neq "!sourceTemp!" (
                set "COPY_ENTEGOR_HKB_FLAG=YES"
                set "target=!target:%PATH_ENTEGOR_GITBLIT%%PRD_DATE%\hkb\=!"
                set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKB!!target!"
                set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKB!"
            )
            
            set "temp=!sourceTemp:\hks\=!"
            if "!temp!" neq "!sourceTemp!" (
                set "COPY_ENTEGOR_HKS_FLAG=YES"
                set "target=!target:%PATH_ENTEGOR_GITBLIT%%PRD_DATE%\hks\=!"
                set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKS!!target!"
                set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKS!"
            )
            
            set "temp=!sourceTemp:\hku\=!"
            if "!temp!" neq "!sourceTemp!" (
                set "COPY_ENTEGOR_HKU_FLAG=YES"
                set "target=!target:%PATH_ENTEGOR_GITBLIT%%PRD_DATE%\hku\=!"
                set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKU!!target!"
                set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKU!"
            )
        )
        
        Rem ETL路径处理
        set "temp=!str:\ETL\=!"
        if "!temp!" neq "!str!" (
            set "COPY_ETL_FLAG=YES"
            set "target=!target:%PATH_ETL_GITBLIT%=!"
            set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_BATCH!!target!"
            set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!!target!"
        
            Rem 特殊处理PRD配置文件
            set "prd_config=!str:\prd\=!"
            if "!prd_config!" neq "!str!" (
                set "target=!target:bin\prd\=bin\!"
                set "copy_path=!PATH_TRUE_CODING!!ARTIFACTORY_PKG_BATCH!!target!"
                set "temp_copy_path=!PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!!target!"
            )
        )
        
        Rem 比较文件内容，先检查Coding工程中是否存在，以判断是否为新增投产物
        if exist "!copy_path!" (
            Rem 提取文件扩展名（转为小写）
            for %%f in ("!copy_path!") do set "ext_copy=%%~xf"
            set "match_copy=false"
            for %%e in (!allowed_exts!) do (
                if /i "!ext_copy!"=="%%e" set "match_copy=true"
            )
            
            if "!match_copy!"=="true" (
                echo 文件1：!str! VS 文件2：!copy_path! >> "%logFile%"
                Rem 二进制比较
                fc /b "!str!" "!copy_path!" >nul
                if !errorlevel! equ 0 (
                    echo !filepath!!C_SEPARATOR!!user! 内容未变更无需投产！！！
                    echo !filepath!!C_SEPARATOR!!user! 内容未变更无需投产！！！ >> "%missFile%"
                    set /a "noneed_count+=1"
                    set /a "processed_count+=1"
                ) else (
                    if "!COPY_EBI_HKB_FLAG!"=="YES" (
                        echo Copy EBI资源（分行）!str! TO !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKB! >> "%logFile%"
                        copy !str! !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKB!
                        if !errorlevel! equ 0 (set /a "processed_count+=1")
                    ) else if "!COPY_EBI_HKS_FLAG!"=="YES" (
                        echo Copy EBI资源（子行）!str! TO !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKS! >> "%logFile%"
                        copy !str! !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKS!
                        if !errorlevel! equ 0 (set /a "processed_count+=1")
                    ) else if "!COPY_EBI_HKU_FLAG!"=="YES" (
                        echo Copy EBI资源（分子行）!str! TO !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKU! >> "%logFile%"
                        copy !str! !PATH_TEMP_CODING!!ARTIFACTORY_PKG_EBI_HKU!
                        if !errorlevel! equ 0 (set /a "processed_count+=1")
                    ) else if "!COPY_ENTEGOR_HKB_FLAG!"=="YES" (
                        echo Copy Entegor资源（分行）!str! TO !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKB! >> "%logFile%"
                        copy !str! !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKB!
                        if !errorlevel! equ 0 (set /a "processed_count+=1")
                    ) else if "!COPY_ENTEGOR_HKS_FLAG!"=="YES" (
                        echo Copy Entegor资源（子行）!str! TO !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKS! >> "%logFile%"
                        copy !str! !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKS!
                        if !errorlevel! equ 0 (set /a "processed_count+=1")
                    ) else if "!COPY_ENTEGOR_HKU_FLAG!"=="YES" (
                        echo Copy Entegor资源（分子行）!str! TO !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKU! >> "%logFile%"
                        copy !str! !PATH_TEMP_CODING!!ARTIFACTORY_PKG_ENTEGOR_HKU!
                        if !errorlevel! equ 0 (set /a "processed_count+=1")
                    ) else if "!COPY_ETL_FLAG!"=="YES" (
                        echo Copy ETL脚本!str! TO !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!!target! >> "%logFile%"
                        copy !str! !PATH_TEMP_CODING!!ARTIFACTORY_PKG_BATCH!!target!
                        if !errorlevel! equ 0 (set /a "processed_count+=1")
                    ) else (
                        echo !str! 未处理文件！！！
                        echo !str! 未处理文件！！！ >> "%logFile%"
                        echo !str! 未处理文件！！！ >> "%missFile%"
                    )
                )
            ) else (
                echo !str! 扩展名不在有效范围内！！！
                echo !str! 扩展名不在有效范围内！！！ >> "%logFile%"
                set /a "processed_count+=1"
            )
        ) else (
            echo Copy新增文件：!copy_path!
            echo Copy新增文件：!copy_path! >> "%logFile%"
            copy !str! !temp_copy_path! >nul
            if !errorlevel! equ 0 (set /a "processed_count+=1")
        )
    ) else (
        echo "!filepath!!C_SEPARATOR!!user! 文件不存在（Error）！！！"
        echo "!filepath!!C_SEPARATOR!!user! 文件不存在（Error）！！！" >> "%missFile%"
        set /a "miss_count+=1"
        set /a "processed_count+=1"
    )
)

Rem 统计拷贝文件总数（递归）
for /r "%PATH_TEMP_CODING%" %%f in (*) do (
    set /a "file_count+=1"
)

echo "检查完成！（处理文件数：!processed_count!，拷贝文件数：!file_count!，无需投产文件数：!noneed_count!，路径错误文件数：!miss_count!）"
echo.
echo "检查完成！（处理文件数：!processed_count!，拷贝文件数：!file_count!，无需投产文件数：!noneed_count!，路径错误文件数：!miss_count!）" >> "%logFile%"

echo 按任意键回到菜单~
pause >nul
goto :gate

endlocal
