# LangChain + OceanBase 混合搜索工作坊

欢迎参加 LangChain + OceanBase 混合搜索工作坊！🎉

> **🔔 重要提醒**
> 1. **OceanBase 连接**：讲师会提供在线数据库实例的 IP 和端口，请更新到 `.env` 文件
> 2. **API Key**：SiliconFlow API Key 已经配置好，无需修改
> 3. **开始前**：确保完成环境配置（见下方快速开始）

## 📋 工作坊目标

在 20 分钟内完成 **Notebook 03 - 混合搜索** 的填空练习，学习如何使用 OceanBase 实现向量、稀疏和全文的混合搜索。

## 🏆 比赛规则

- **任务**：填写 Notebook 03 中所有标记为 `______` 的空白
- **评分**：统计**正确运行**的单元格数量
- **获胜者**：正确回答最多的参与者

## 🚀 快速开始

### 1️⃣ 安装依赖

确保你已安装 [uv](https://docs.astral.sh/uv/)，然后运行：

```bash
uv sync
```

这会自动安装所有需要的依赖包。

### 2️⃣ 配置环境变量

复制 `.env.example` 并重命名为 `.env`：

```bash
cp .env.example .env
```

**⚠️ 重要配置说明：**

编辑 `.env` 文件，**仅需修改以下内容**：

✅ **需要修改**：
- `OCEANBASE_HOST`：在线数据库实例的 IP 地址（讲师会提供）
- `OCEANBASE_PORT`：在线数据库实例的端口（讲师会提供）

✅ **已配置好（无需修改）**：
- `SILICONFLOW_API_KEY`：已填写，直接使用即可
- `SILICONFLOW_CHAT_MODEL`：已配置为 Qwen/Qwen2.5-7B-Instruct
- `SILICONFLOW_EMBEDDING_MODEL`：已配置为 BAAI/bge-m3

> 💡 **提示**：讲师会在工作坊开始时提供 OceanBase 在线实例的连接信息

### 3️⃣ 启动 Jupyter Notebook

**方式 1：使用 IDE 的 Jupyter 扩展**（推荐）

- VS Code：安装 [Jupyter 扩展](https://marketplace.visualstudio.com/items?itemName=ms-toolsai.jupyter)
- PyCharm：内置 Jupyter 支持
- 直接打开 `notebooks/03-hybrid-search.ipynb`

**方式 2：使用命令行**

```bash
uv run jupyter notebook
```

然后在浏览器中打开 `notebooks/03-hybrid-search.ipynb`

## 📚 Notebook 概览

### Notebook 01 - 构建知识库
- 加载 PDF 文档（Nike 10-K 年报）
- 文本切分和向量化
- 存储到 OceanBase

### Notebook 02 - Agentic RAG
- 创建智能 Agent
- Agent 自主决策何时检索
- 对比传统 RAG 和 Agentic RAG

### Notebook 03 - 混合搜索 ⭐（工作坊重点）
- **练习 1-2**：添加文档和稀疏向量
- **练习 3**：纯向量搜索
- **练习 4**：稀疏向量搜索
- **练习 5**：全文搜索
- **练习 6**：均衡权重混合搜索
- **练习 7**：语义权重优先
- **练习 8**：关键词权重优先
- **练习 9**：在工具函数中使用混合搜索

## 🎯 练习指南

### 空白标记

需要填写的地方用 `______` 标记，例如：

```python
# 🎯 练习 1: 添加带全文内容的文档
# 提示：使用 add_documents_with_fulltext() 方法
# 参数：documents=demo_docs, fulltext_content=fulltext_content
ids = hybrid_store.______(
    documents=______,
    fulltext_content=______
)
```

### 每个练习包含

- 🎯 **练习编号和描述**
- 💡 **提示**：方法名和参数说明
- 📖 **参考文档链接**

### 如何验证答案

1. 填写空白后，按 `Shift + Enter` 运行单元格
2. 如果单元格**成功运行并产生输出**，说明答案正确 ✅
3. 如果出现错误，检查方法名和参数是否正确 ❌

## 📖 参考资源

- **OceanBase Vector Store API**：[GitHub 文档](https://github.com/oceanbase/langchain-oceanbase)
- **LangChain 文档**：[python.langchain.com](https://python.langchain.com/)
- **混合搜索原理**：参考 Notebook 03 开头的说明

## 💡 提示和技巧

### 三种搜索模式速查

| 模式 | 方法名 | 适用场景 |
|------|--------|----------|
| **向量搜索** | `similarity_search()` | 语义相似度 |
| **稀疏搜索** | `similarity_search_with_sparse_vector()` | 关键词匹配 |
| **全文搜索** | `similarity_search_with_fulltext()` | 精确短语 |
| **混合搜索** | `advanced_hybrid_search()` | 组合所有模式 |

### 权重配置示例

```python
# 均衡权重（通用）
{'vector': 0.4, 'sparse': 0.3, 'fulltext': 0.3}

# 语义优先（概念查询）
{'vector': 0.7, 'sparse': 0.2, 'fulltext': 0.1}

# 关键词优先（特定术语）
{'vector': 0.2, 'sparse': 0.6, 'fulltext': 0.2}

# 精确匹配优先（法律文本）
{'vector': 0.1, 'sparse': 0.2, 'fulltext': 0.7}
```

## 🐛 常见问题

### 1. 环境安装失败

```bash
# 确保 Python 版本 >= 3.10
python --version

# 重新安装
rm -rf .venv
uv sync
```

### 2. OceanBase 连接失败

**首先确认**：你是否已更新 `.env` 文件中的在线数据库配置？

检查 `.env` 文件中的配置：
- `OCEANBASE_HOST`：应该是讲师提供的在线实例 IP
- `OCEANBASE_PORT`：应该是讲师提供的在线实例端口
- `OCEANBASE_USER`：通常为 `root`
- `OCEANBASE_PASSWORD`：如果有密码，讲师会提供

> 💡 如果讲师还未提供连接信息，请举手询问

### 3. 找不到模块

确保在正确的 Python 环境中运行：

```bash
# 使用 uv 运行
uv run jupyter notebook

# 或激活虚拟环境
source .venv/bin/activate  # macOS/Linux
.venv\Scripts\activate     # Windows
```

## 📞 获取帮助

如果遇到问题：

1. 查看 Notebook 中的提示和说明
2. 参考 [OceanBase 文档](https://github.com/oceanbase/langchain-oceanbase)
3. 查看其他 Notebook 的示例代码
4. 举手向讲师求助 🙋

## 🎊 祝你好运！

准备好了吗？让我们开始探索混合搜索的强大功能！🚀

记住：
- ✅ 仔细阅读每个练习的提示
- ✅ 运行单元格验证答案
- ✅ 理解每种搜索模式的适用场景
- ✅ 享受学习过程！

**加油！期待看到你的精彩表现！** 💪
