import java.sql.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TestLB {
    public static void select(int threadNum) throws SQLException {
        String url = "jdbc:oceanbase:loadbalance://172.24.28.15:2883:1,172.24.28.16:2883:1,172.24.28.13:2883:1/test?user=root@test#obcluster&password=BBbb22__&loadBalanceStrategy=serverAffinity";
        String selectSql = "SELECT host_ip() as host_ip FROM dual";
        
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            conn = DriverManager.getConnection(url);
            ps = conn.prepareStatement(selectSql);
            rs = ps.executeQuery();
            
            while (rs.next()) {
                System.out.println(String.format("线程 %d: ### %s ###", threadNum, rs.getString("host_ip")));
            }
            
            Thread.sleep(300000); // 等待300秒
            
        } catch (ClassNotFoundException e) {
            System.err.println("OceanBase JDBC驱动未找到: " + e.getMessage());
        } catch (SQLException e) {
            System.err.println("数据库操作失败: " + e.getMessage());
        } catch (InterruptedException e) {
            System.err.println("线程被中断: " + e.getMessage());
            Thread.currentThread().interrupt();
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    // 任务类，用于执行 select 方法
    public static class SelectTask implements Runnable {
        private final int threadNum;

        public SelectTask(int threadNum) {
            this.threadNum = threadNum;
        }

        @Override
        public void run() {
            try {
                select(threadNum);
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        int threadCount = 20; // 默认创建20个线程
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        
        System.out.println("启动 " + threadCount + " 个线程进行数据库连接测试...");
        
        for (int i = 1; i <= threadCount; i++) {
            executor.submit(new SelectTask(i));
        }
        
        executor.shutdown();
    }
}
